/*
*
*
*
* DEBUT FONCTIONS TERMINEES
*
*
*
*/


// Mise à jour de la valeur clinimètre après changement sur le thermomètre
// Met à jour le score visuellement et l'injecte dans le localStorage
function updateThermometre(that) {
        
		var valeur_champ = $(that).find('input').val();
        
        // Convertir valeur de précision du range en valeur clinimetre et grille
        var lvlthermo = __LVLTHERMOMIN__;
		var pasthermo = __NBLVLTHERMO__ / __NBLVLCLINIMETRE__;
        var lvlclinimetre = __LVLCLINIMETREMIN__;
        
        for(lvlthermo; lvlthermo < __NBLVLTHERMO__; lvlthermo += pasthermo) {        
                
                if (valeur_champ >= lvlthermo && valeur_champ < lvlthermo + pasthermo) {
                        var valclinimetre = lvlclinimetre;
                        var valgrille = clinimetreToGrille(valclinimetre);
                }
                lvlclinimetre++;
        }
		
		// On met à jour le curseur
		updateCurseur(valeur_champ);
		
		// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
        updateValeurClinimetreGrille(valclinimetre);        
		
		// On met à jour le détail du score de la fonction courante
		updateSubGrille(valgrille);
		
		// On met à jour le score à partir du localStorage
        updateScore();                                
}


// Met à jour visuellement le radar d'après le localStorage
function updateRadar()
{
	var idGrille = __DOCTEUR__.idLastGrille;
	var listeFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
	
	// Liste de valeurs la plus récente
	var valeursGrille = getCurrentDataGrille();
	
	// CORRECTION DE BUG : Petite astuce pour les Android qui habituellement affichent 2 radars donc un fixe...
    if(__TERMINAL__ == 'Android') {
		// On supprime le radar
		$('#spidergraphcontainer').html();
         
		// Et on en génère un nouveau
		$('#spidergraphcontainer').spidergraph4({
				'fields': listeFonctions,
				'gridcolor': 'rgba(0,0,0,1)'   
		});
	updateScore(); 
	}
    
	// Sinon on vide le layer actuel
    else {
		if(idGrille==1){
		
    	$('#spidergraphcontainer').spidergraph('resetdata');
		}
		if(idGrille==2)
		{
		$('#spidergraphcontainer').spidergraph2('resetdata');
		
		}
		if(idGrille==3)
		{
		$('#spidergraphcontainer').spidergraph3('resetdata');
		}
		if(idGrille==4)
		{
		$('#spidergraphcontainer').spidergraph4('resetdata');
		}
		
	}
	
	// Pour en installer un nouveau
	if(idGrille==1){
    $('#spidergraphcontainer').spidergraph('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	
	if(idGrille==2){
    $('#spidergraphcontainer').spidergraph2('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	
	if(idGrille==3){
    $('#spidergraphcontainer').spidergraph3('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	if(idGrille==4){
    $('#spidergraphcontainer').spidergraph4('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	
	
  
        
    // CORRECTION DE BUG : Reselectionne le bon champs d'entrée de radar
	var i = parseInt($('#thermometre').attr('name'));
	updateCurrentFonctionName(i);
        
}





// Récréé intégralement le radar

function createRadar(idGrilleInput) {

	if(typeof idGrilleInput == 'undefined'){
		var idGrille = __DOCTEUR__.idLastGrille;
	}
	else{
		var idGrille = idGrilleInput;
	}

	//var idGrille = __DOCTEUR__.idLastGrille;
	var listeFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
	
	// Liste de valeurs la plus récente
	var valeursGrille = getCurrentDataGrille();
	
	// On supprime le radar
	$('#spidergraphcontainer').html();
         
	// Et on en génère un nouveau
	if(idGrille == 1)
	{
	$('#spidergraphcontainer').spidergraph({
			'fields': listeFonctions,
			'gridcolor': 'rgba(0,0,0,1)'   
	});
	
	// Pour en installer un nouveau
    $('#spidergraphcontainer').spidergraph('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	if(idGrille == 2)
	{
	$('#spidergraphcontainer').spidergraph2({
			'fields': listeFonctions,
			'gridcolor': 'rgba(0,0,0,1)'   
	});
	
	// Pour en installer un nouveau
    $('#spidergraphcontainer').spidergraph2('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	if(idGrille == 3)
	{
	$('#spidergraphcontainer').spidergraph3({
			'fields': listeFonctions,
			'gridcolor': 'rgba(0,0,0,1)'   
	});
	
	// Pour en installer un nouveau
    $('#spidergraphcontainer').spidergraph3('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
	if(idGrille == 4)
	{
	$('#spidergraphcontainer').spidergraph4({
			'fields': listeFonctions,
			'gridcolor': 'rgba(0,0,0,1)'   
	});
	
	// Pour en installer un nouveau
    $('#spidergraphcontainer').spidergraph4('addlayer', {         
  	 	'strokecolor': 'rgba(0,0,0,1)',
        'fillcolor': __FILLCOLOR__,
		'data': valeursGrille,
		'linear': true
    });
	}
      
    // CORRECTION DE BUG : Reselectionne le bon champs d'entrée de radar
	var i = parseInt($('#thermometre').attr('name'));
	
	updateCurrentFonctionName(i);
	updateScore(); 
}



// Sauvegarde une valeur clinimetre dans le LocalStorage
function saveLSClinimetreValue(valeur, idFonction, idPatient, date) {
	
	// Attributs et initialisation
	if(typeof valeur != 'undefined') {
		
		console.log('Mise à jour du localStorage...');
		
		var idGrille = __DOCTEUR__.idLastGrille;
		var idFctn = parseInt($('#thermometre').attr('name'));
		var updatesDates = getClinimetreUpdatesDates();
		
		if(typeof idFonction == 'undefined') {idFonction = parseInt(__LISTEGRILLES__[idGrille].idFonctions[idFctn]);}
		if(typeof idPatient == 'undefined') {idPatient = __DOCTEUR__.idLastPatient;}
		if(typeof date == 'undefined') { date = __PARAMETRES__.currentDate; }
		
		// On met à jour les variables globales (?)
		__DONNEESCLINIMETRE__ = JSON.parse(localStorage.getItem('donneesClinimetre'));
		
		// On insère la nouvelle valeur
		__DONNEESCLINIMETRE__[idPatient][idFonction][date] = {'id':'', 'valeur':parseInt(valeur)};
		
		// On met à jour le localStorage (on supprime d'abord la valeur puis on injecte la nouvelle)
		localStorage.removeItem('donneesClinimetre');
		localStorage.setItem('donneesClinimetre', JSON.stringify(__DONNEESCLINIMETRE__));
		
		console.log('localStorage à jour !');
		
	}
	else {console.log('Aucune valeur renseignee');}
}



// Modifie la date de l'analyse/objectifs courant dans le localStorage
function saveLSDate() {
	var idGrille = __DOCTEUR__.idLastGrille;
	var idPatient = __DOCTEUR__.idLastPatient;
	var updatesDates = getClinimetreUpdatesDates();
	var dateObjectifs = updatesDates[updatesDates.length-1];

	var idFonction = parseInt(__LISTEGRILLES__[idGrille].idFonctions[i]);

	for(var i = 0; i < __LISTEGRILLES__[idGrille].idFonctions.length; i++) {
		idFonction = __LISTEGRILLES__[idGrille].idFonctions[i];
		// On applique les anciennes données dans la nouvelle date
		__DONNEESCLINIMETRE__[idPatient][idFonction][__PARAMETRES__.currentDate] = __DONNEESCLINIMETRE__[idPatient][idFonction][dateObjectifs];

		// Puis on supprime l'ancienne date
		delete __DONNEESCLINIMETRE__[idPatient][idFonction][dateObjectifs];
	}

	// On met à jour le localStorage (on supprime d'abord la valeur puis on injecte la nouvelle)
	localStorage.removeItem('donneesClinimetre');
	localStorage.setItem('donneesClinimetre', JSON.stringify(__DONNEESCLINIMETRE__));
}



// Fonction de traitement lors de l'appui sur la flèche du bas
function fonctionSuivante() {

	// Infos sur la grille
	var idGrille = __DOCTEUR__.idLastGrille;
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	 
	// Liste de valeurs la plus récente
	var valeursGrille = getCurrentDataGrille();
	
	var grillefonction = $('#grille_fonction');
	var i = parseInt(grillefonction.attr("name"));
   	var newVal = '';
   
   	// Gestion en boucle (dernier -> premier)
   	if(i == nbChampsGrille-1) {
		newVal = __LISTEGRILLES__[idGrille].libelleFonctions[0];
		i = 0;
	} else {
		newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i+1];
		i++;
	}
	
	// Mise à jour du texte
	grillefonction.html(newVal);
	
	updateCurrentFonctionName(i);
	
	// On met à jour le curseur
	var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
	var valthermo = valeursGrille[i] * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
	
	updateCurseur(valthermo);
 
	// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i]));        
	
	// On met à jour le détail du score de la fonction courante
	updateSubGrille(valeursGrille[i]);  	
	updateScore(); 
}

// Fonction de traitement lors de l'appui sur la flèche du haut                                     
function fonctionPrecedente() {
                           
	// Infos sur la grille
	var idGrille = __DOCTEUR__.idLastGrille;
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	 
	// Liste de valeurs la plus récente
	var valeursGrille = getCurrentDataGrille();
	
	var grillefonction = $('#grille_fonction');
	i = parseInt(grillefonction.attr("name"));
   	var newVal = '';
   
   	// Gestion en boucle (premier -> dernier)
   	if(i == 0) {
		newVal = __LISTEGRILLES__[idGrille].libelleFonctions[nbChampsGrille-1];
		i = nbChampsGrille-1;
	} else {
		newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i-1];
		i--;
	}
	
	// Mise à jour du texte
	grillefonction.html(newVal); 
	
	updateCurrentFonctionName(i);  
	
	// On met à jour le curseur
	var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
	var valthermo = valeursGrille[i] * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
	
	updateCurseur(valthermo);
 
	// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i]));        
	
	// On met à jour le détail du score de la fonction courante
	updateSubGrille(valeursGrille[i]);      
	updateScore(); 	
}

// Insert le nom de la fonction courante
// après changement via les flèche, le radar ou la liste
function updateCurrentFonctionName(i) {
	
	// Infos sur la grille
	var idGrille = __DOCTEUR__.idLastGrille;
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	
	// Mise à jour du nom du texte
	$('#grille_fonction').attr("name", i);    
	
	// Répercutions sur le thermometre, la liste et le radar
	$('#thermometre').attr("name", i);
	
	$('.fonctions_liste_ligne').removeClass("fonction_current");
	$('.fonctions_liste_ligne').eq(i).addClass("fonction_current");
	
	$('.diagramText').removeClass("fonction_current");
	$('.diagramText').eq(nbChampsGrille-i-1).addClass("fonction_current");  
	updateScore(); 
}

// Met en avant la fonction courante sur le radar
function clickTextRadar(i) {

	// Infos sur la grille
	var idGrille = __DOCTEUR__.idLastGrille;
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	 
	// Liste de valeurs la plus récente
	var valeursGrille = getCurrentDataGrille();
	
	var grillefonction = $('#grille_fonction');
	var newVal = __LISTEGRILLES__[idGrille].libelleFonctions[i];

	// Mise à jour du texte
	grillefonction.html(newVal); 
	
	updateCurrentFonctionName(i);
	
	// On met à jour le curseur
	var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
	var valthermo = valeursGrille[i] * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
	
	updateCurseur(valthermo);
 
	// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valeursGrille[i]));        
	
	// On met à jour le détail du score de la fonction courante
	updateSubGrille(valeursGrille[i]); 	
	updateScore(); 
	
}

// Met en avant la fonction courante sur la liste
function clickTextSondage(i) {
	clickTextRadar(i);
}


// Mise à jour du détail de la fonction courante
function updateSubGrille(valgrille) {
        var detail = $("#fonction_detail");
        var id = valgrille - __LISTEGRILLES__[__DOCTEUR__.idLastGrille].nivGrilleMin;
        detail.text(__LISTEGRILLES__[__DOCTEUR__.idLastGrille].listeDescValeursGrille[id]);
		updateScore(); 
}





// Renvoie les valeurs les plus récentes de la grille actuelle d'après le localStorage
function getCurrentDataGrille(date) {
	
	// Init
	date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;
	
	var valeursClinimetre = getCurrentDataClinimetre(date);
	var valeursGrille = [];

	for(var i = 0; i < valeursClinimetre.length; i++){
		// On insère la valeur convertie
		valeursGrille.push(clinimetreToGrille(valeursClinimetre[i]));
	}
	console.log("Valeurs grille les plus proche (datant du " + __PARAMETRES__.currentDate + ") : "+ valeursGrille);
	return valeursGrille;
}


// Renvoie les valeurs les plus récentes du clinimetre actuel d'après le localStorage
function getCurrentDataClinimetre(date) {
	
	// Init 
	date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;
	
	var id_grille = __DOCTEUR__.idLastGrille;
	var id_patient = __DOCTEUR__.idLastPatient;
	
	var nbChampsGrille = __LISTEGRILLES__[id_grille].libelleFonctions.length;
	var donneesPatient = __DONNEESCLINIMETRE__[id_patient];
	var idFonctions = __LISTEGRILLES__[id_grille].idFonctions;

	var valeursClinimetre = [];
	var strDte = '';

	var offset = -1;
	if(dateToString() < __PARAMETRES__.currentDate) { offset = 1; }
	
	var flag = 'ok';

	// Déterminer la date de la dernière modification
	var lastUpdate = '0000/00/00';
	
	for(var i = 0; i < nbChampsGrille; i++){
		var fini = false;
		var currentDate = new Date(date);
		
		// On insère une valeur par défaut
		valeursClinimetre.push(0);
		
		// Longueur de l'historique max (1 an)
		var j = 365;
		
		while(!fini) {

			// Modification de la date de la recherche
			strDte = dateToString(currentDate);

			if(typeof donneesPatient[idFonctions[i]][strDte] !== 'undefined') {
				
				// Insertion de la valeur
				valeursClinimetre[i] = donneesPatient[idFonctions[i]][strDte].valeur;

				// Mise à jour de la date de la dernière modification
				//console.log(i + ' : ' + lastUpdate +'; '+ strDte);
				if(lastUpdate < strDte) { lastUpdate = strDte; }

				fini = true;
			}
			
			// On arrete la recherche au bout d'un nombre d'execution donné
			else if(j == 0) {
				console.log("Les valeurs enregistrees sont erronees.");
				flag = 'nok';
				fini = true;
			}
			
			currentDate.setDate(currentDate.getDate() + offset);	
			j--;
		}
	}

	if (flag == 'nok') {

	}
	//__PARAMETRES__.currentDate = lastUpdate;

	// Si on cherche des données futures pour l'analyse et objectifs
	/*if(offset == 1) {
		
		// Si on a trouvé des valeurs dans le futur
		if(flag == 'ok') {
			// On applique la date des analyses et objectifs 
			__PARAMETRES__.currentDate = strDte;

		} else {
			// On applique la date du jour + 14
			var tdy = new Date();
			__PARAMETRES__.currentDate = dateToString(tdy);

			// On restitue les valeursClinimetre du jour
			valeursClinimetre = getCurrentDataClinimetre();

			// On applique la date du jour + 14
			tdy.setDate(tdy.getDate() + 14);
			__PARAMETRES__.currentDate = dateToString(tdy);			
		}
	}*/

	console.log("Valeurs clinimetre les plus proche (datant du " + __PARAMETRES__.currentDate + ") : "+ valeursClinimetre);
	return valeursClinimetre;
}


// Renvoie les dates des dernières mise à jour sur les données
function getClinimetreUpdatesDates() {
	
	var id_grille = __DOCTEUR__.idLastGrille;
	var id_patient = __DOCTEUR__.idLastPatient;
	var date = __PARAMETRES__.currentDate;
	var nbChampsGrille = __LISTEGRILLES__[id_grille].libelleFonctions.length;
	var donneesPatient = __DONNEESCLINIMETRE__[id_patient];
	
	var strDte = '';
	var updatesDates = [];

	// Aujourd'hui
	var tdy = new Date();
	var strtdy = dateToString(tdy);
	updatesDates.push(strtdy);
	
	for(var i = 1; i <= nbChampsGrille; i++){
		var fini = false;
		var currentDate = new Date();
		currentDate.setDate(currentDate.getDate() + 14);

		// Longueur de l'historique max (1 an)
		var j = 365;
		
		while(!fini) {

			// Modification de la date de la recherche
			strDte = dateToString(currentDate);

			if(typeof donneesPatient[i][strDte] !== 'undefined' &&
				updatesDates.indexOf(strDte) == -1) {
				
				// Mise à jour de la date de la dernière modification
				updatesDates.push(strDte);

				fini = true;
			}
			
			// On arrete la recherche au bout d'un nombre d'execution donné
			else if(j == 0) {
				console.log("Les valeurs enregistrees sont erronees.");
				fini = true;
			}
			
			currentDate.setDate(currentDate.getDate() - 1);	
			j--;
		}
	}

	return updatesDates.sort();
}



// Renvoie la date de la dernière mise à jour par rapport a une date
function getClinimetreLastUpdateDate(date) {
	
	date = typeof date !== 'undefined' ? date : __PARAMETRES__.currentDate;
	var updatesDates = getClinimetreUpdatesDates();
	
	var res = '';
	var fini = false;

	var i = updatesDates.length;

	while(i > 0 || !fini){
		
		// Valeur la plus proche de la date
		if(updatesDates[i] <= date) {
			res = updatesDates[i];
			fini = true;
		}

		i--;
	}
		
	return res;
}



// Transforme une date en une chaine (gestion des 9 premiers jours)
function dateToString(date) {

	date = typeof date !== 'undefined' ? date : new Date();
	
	var jr = date.getDate();
	if(jr >= 1 && jr <= 9) {jr = "0" + jr;}
	
	var mois = date.getMonth()+1;
	if(mois >= 1 && mois <= 9) {mois = "0" + mois;}
	
	var res = date.getFullYear() + "/" + mois + "/" + jr;

	return res;
}


// Position le curseur à l'endroit du clic
function updateCurseur(valgrille) {
        
	var margin = (82*valgrille)/__NBLVLTHERMO__ + 9;
    $("#thermometre_curseur").css('margin-left', margin + '%');
}


// Identifie l'evaluateur
// Recupère les données depuis la base de données
// Peuple le localStorage
function loadFromLocalStorage(varlogin, varpasswd) {

	var flag = 'nok';
	
	// Si le navigateur est en ligne
	if(navigator.onLine) {
			
		console.log("Mode en-ligne");
		
		var requete = $.ajax({
    	   	url      : "include/getAllData.php",
            type     : "GET",
			data	 : {'login' : varlogin, 'passwd' : varpasswd},
            dataType : "json",
			async	 : false,
            success  : function(res) {        
                
				if(res.flag == 'ok') {                
                	
					/*

					IL FAUT SYNCHRONISER LE LOCALSTORAGE ET LA BDD
					ET NON ECRASER LE LS AVEC LA BDD

					*/

					localStorage.clear();

					console.log("Vous etes correctement identifie");
					//console.log("Mise a jour du localStorage depuis la bdd");
					
					var varEtablissement = res.etablissement;
					localStorage.setItem('etablissement', JSON.stringify(varEtablissement));

					var varDocteur = res.docteur;
					localStorage.setItem('docteur', JSON.stringify(varDocteur));

					var varListePatients = res.patients;
					localStorage.setItem('listePatients', JSON.stringify(varListePatients));

					var varListeGrilles = res.grilles;
					localStorage.setItem('listeGrilles', JSON.stringify(varListeGrilles));

					var varDonneesClinimetre = res.donneesclinimetre;
					localStorage.setItem('donneesClinimetre', JSON.stringify(varDonneesClinimetre));

					var varParametres = res.parametres;
					
					var varReponsePatient = res.reponsepatient;
					localStorage.setItem('reponsePatient', JSON.stringify(varReponsePatient));

					varParametres.currentPage = "pageDeConnexion";
					varParametres.currentDate = dateToString();
					
					localStorage.setItem('parametres', JSON.stringify(varParametres));
					
					flag = 'ok';
									                   
    	        }
				else {
					console.log("Impossible de recuperer les informations. Vous n'etes pas correctement identifie.");
					alert("Impossible de recuperer les informations. Vous n'etes pas correctement identifie.");
				}
			}
		}).done(function(){
			
			console.log('##### MISE A JOUR DU LOCALSTORAGE DEPUIS LA BDD : ' + flag + ' #####');
		});

	}
	
	else {
	
		alert("Vous etes mode hors-ligne. Connectez-vous a un reseau mobile ou wifi afin de recuperer les dernieres donnees");
		console.log('##### MISE A JOUR DU LOCALSTORAGE DEPUIS LA BDD : ' + flag + ' #####');
	}
	
	if(varlogin == JSON.parse(localStorage.getItem('docteur')).login &&
		varpasswd == JSON.parse(localStorage.getItem('docteur')).passwd) {

		flag = 'nok';
		
		// On recupere le contenu du localStorage
		if(localStorage.getItem('docteur') !== null){
			__DOCTEUR__ = JSON.parse(localStorage.getItem('docteur'));
		}

		if(localStorage.getItem('etablissement') !== null){
			__ETABLISSEMENT__ = JSON.parse(localStorage.getItem('etablissement'));
		}

		if(localStorage.getItem('listePatients') !== null){
			__LISTEPATIENTS__ = JSON.parse(localStorage.getItem('listePatients'));
		}

		if(localStorage.getItem('listeGrilles') !== null){
			__LISTEGRILLES__ = JSON.parse(localStorage.getItem('listeGrilles'));
		}
		
		if(localStorage.getItem('reponsePatient') !== null){
			__REPONSEPATIENT__ = JSON.parse(localStorage.getItem('reponsePatient'));
		}
		
		if(localStorage.getItem('donneesClinimetre') !== null){
			__DONNEESCLINIMETRE__ = JSON.parse(localStorage.getItem('donneesClinimetre'));
		}

		if(localStorage.getItem('parametres') !== null){
			__PARAMETRES__ = JSON.parse(localStorage.getItem('parametres'));
		}	
				
		flag = 'ok';
		console.log('##### MISE A JOUR DES VARIABLES GLOBALES DEPUIS LE LOCALSTORAGE : ' + flag + ' #####');
	}
}
	

// Charge une page choisie
function loadPage(pageToLoad) {

	// Si pageToLoad n'est pas renseigné, on va sur "pageRadar" par defaut
	pageToLoad = typeof pageToLoad !== 'undefined' ? pageToLoad : "pageDeConnexion";


	
	// On change la page courante enregistrée
	__PARAMETRES__.currentPage = pageToLoad;
	localStorage.removeItem('parametres');
	localStorage.setItem('parametres', JSON.stringify(__PARAMETRES__));
	
	// Preparation des informations
	var idPatient = __DOCTEUR__.idLastPatient;
	var idGrille = __DOCTEUR__.idLastGrille;
	
	var nomPatient = __LISTEPATIENTS__[idPatient].nom;
	var prenomPatient = __LISTEPATIENTS__[idPatient].prenom;
	var sexePatient = __LISTEPATIENTS__[idPatient].sexe;
	var numDossierPatient = __LISTEPATIENTS__[idPatient].num_dossier;
	
	var libelleGrille = __LISTEGRILLES__[idGrille].libelle;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
	var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	var libelleFonction = __LISTEGRILLES__[idGrille].libelleFonctions[0];
	
	var donneesPatient = __DONNEESCLINIMETRE__[idPatient];
	var valeursGrille = getCurrentDataGrille();
	
	var corps = '';
		
	if(pageToLoad != 'pageDeConnexion') {
	
		// ### Masquage du formulaire de connexion ###

		var formconnexion = $('#blocconnexion');
		
		// On masque le formulaire de connexion celui-ci était affiché		
		if(!formconnexion.hasClass('hidden')) {
			formconnexion.addClass('hidden');
		}
	
		// ### Affichage des bandeaux 3 et 4, de la flèche du haut et du footer ###
		
		var bandeau3 = $('#troisieme_bandeau');
		var bandeau4 = $('#quatrieme_bandeau');
		var flechehaut = $('#fleche_haut');
		var footer = $('footer');
		
		// On affiche le bandeau 3 si celui-ci était caché		
		if(bandeau3.hasClass('hidden')) {
			bandeau3.removeClass('hidden');
		}
		
		// On affiche le bandeau 4 si celui-ci était caché		
		if(bandeau4.hasClass('hidden')) {
			bandeau4.removeClass('hidden');
		}
		
		// On affiche la flèche du haut si celle-ci était cachée		
		if(flechehaut.hasClass('hidden')) {
			flechehaut.removeClass('hidden');
		}
		
		// On affiche le footer si celui-ci était caché		
		if(footer.hasClass('hidden')) {
			footer.removeClass('hidden');
		}
		
		// ### Insertion des valeurs dans les champs ###
			
		var etablissement = $('#etablissement');
		var infospatient = $('#infos_patient');
		
		// On affiche le champs si celui-ci était caché et on cache l'etablissement	
		if(infospatient.hasClass('hidden')) {
			infospatient.removeClass('hidden');
			etablissement.addClass('hidden');
		}
		
		// On met à jour les infos du patient
		infospatient.html(nomPatient + ' ' + prenomPatient + '<br /> (' + sexePatient + ') n.' + numDossierPatient);
		
		// On met à jour le nom de la grille
		var grillenom = $('#grille_nom');
		grillenom.html(libelleGrille);
		
		// On met à jour le nom de la fonction
		var grillefonction = $('#grille_fonction');
		grillefonction.html(libelleFonction);
		grillefonction.attr("name", 0);
		
		// On met à jour le détail du score de la fonction
		var fonctiondetail = $('#fonction_detail');
		var valfonction = getCurrentDataClinimetre()[0];
		var detail = __LISTEGRILLES__[idGrille].listeDescValeursGrille[clinimetreToGrille(valfonction)-1];
		fonctiondetail.html(detail);
		fonctiondetail.attr("name", clinimetreToGrille(valfonction));
		
		// On met à jour la valeur clinimetre
		var valclini = $('#valeurclinimetre');
		valclini.html(valfonction);
		
		// On met à jour la valeur grille
		var valgrille = $('#valeurgrille');
		valgrille.html(clinimetreToGrille(valfonction));
		
		// On indique la fonction courante au thermometre
		var thermometre = $('#thermometre');
		thermometre.attr("name", '0');
			
		// On met à jour le curseur
		var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
		var valthermo = valeursGrille[0] * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);

		updateCurseur(valthermo);
		
		// On met à jour la date
		var date = $('#date');
		date.html(__PARAMETRES__.currentDate);

	}
	
	
	// ### PRETRAITEMENT SUR LA HAUTEUR DU BLOC DE CONTENU ###
	
	var y = Math.min(document.documentElement.clientWidth, document.documentElement.clientHeight-405);
	
	var contenu = $('.contenu');
	
	// On masque tous les contenus avant de les afficher		
	contenu.addClass('hidden');
	
	// ### DEBUT LISTE.PHP ###
/*Si la page à charger est liste patient on recharge la page courante et on met la variable
 searchPatient à 1 pour indiquer que le bloc de recherche de patient devrai etre afficher */
if(pageToLoad =="choixPatient")
{
window.location.reload();
sessionStorage.setItem('SearchPatient',1);
}
	
	if(pageToLoad == "pageListe") {
		
		console.log("Page liste");
		
		var listefonctions = $('#fonctions_liste');
		var corps = '';
		
		// On adapte la taille de la liste à l'espace réel restant
		listefonctions.css('height', y);
		
		// On affiche la liste des fonctions si celle-ci était cachée		
		if(listefonctions.hasClass('hidden')) {
			listefonctions.removeClass('hidden');
		}
		
		// On affiche la première ligne
		corps += '<div class="fonctions_liste_ligne0 listesondage0">';
			corps += '<label class="fonctions_liste_nom" id="fonctions_liste_nom_00"> FONCTIONS </label>';
			for(var j = lvlgrillemin; j <= lvlgrillemax; j++){
				corps += '<span class="fonctions_liste_valeur0 sondage">' + j + '</span>';
			}
		corps += '</div>';
		corps += '<div id="champs">';	

		// On affiche toutes les fonctions
		for(var i = 0; i < nbChampsGrille; i++)	{
			
			// On charge la ligne	
			corps += '<div class="fonctions_liste_ligne listesondage';
			if( i == 0 ) {corps += ' fonction_current';}
			corps += '" id="fonctions_liste_ligne_' + i + '" name="' + i + '">';
			
				// On charge le nom de la fonction
				corps += '<label class="fonctions_liste_nom clickable" id="fonctions_liste_nom_' + i + '">' + __LISTEGRILLES__[idGrille].libelleFonctions[i] + '</label>';
			
				// On charge la valeur de la fonction
				corps += '<form class="fonctions_liste_valeurs" id="fonctions_liste_valeurs_' + i + '">';
			
					for(var j = lvlgrillemin; j <= lvlgrillemax; j++){
						corps += '<input class="fonctions_liste_valeur sondage clickable" id="fonctions_liste_valeur_' + j + '" type="checkbox" value="' + j + '" ';
			
						// On coche l'input adéquat
						if(valeursGrille[i] == j) { corps += ' checked';}
			
						corps += '/>';
					}
			
				corps += '</form>';
			
			corps += '</div>';
			
		}
		corps+='</div>';
		listefonctions.html(corps);
		
		// Adapte la largeur des imputs
		var fonctionslistevaleur = $('.fonctions_liste_valeur');
		var fonctionslistenote = $('.fonctions_liste_valeur0');
		
		
		// valwidth = pourcentage pour gérer la largeur des inputs (magie)
		var valwidth = 65;
		var nbLvlTot = (lvlgrillemax - lvlgrillemin + 1);
		var valmargin = (valwidth / (nbLvlTot))-1.5;
		
		fonctionslistevaleur.css('width',valmargin + '%');
		fonctionslistenote.css('width',valmargin-0.3 + '%');
		
	}
	
	if(pageToLoad == "pageQuestions") {
		
		console.log("Page Question");
		
		var listefonctions = $('#questions');
		var corps = '';
		
		// On adapte la taille de la liste à l'espace réel restant
		listefonctions.css('height', y);
		
		// On affiche la liste des fonctions si celle-ci était cachée		
		if(listefonctions.hasClass('hidden')) {
			listefonctions.removeClass('hidden');
		}
		
		corps+=' <form class="centre" method="post" action="ton_action"> <p class="centre">'
		corps+=' <label for="le_nom">La question a choix multiples ?</label><br />'
		corps+=' <select  name="le_nom" id="le_nom" style="width:200px">'
		corps+=' <option  value="ta_valeur">Le nom qui apparaitra</option>'
        corps+=' <option  value="ta_valeur">Le nom qui apparaitra</option>'
        corps+=' <option  value="ta_valeur">Le nom qui apparaitra</option>'
		corps+=' <option  value="ta_valeur">Le nom qui apparaitra</option>'
                   
		corps+=' </select>'
		corps+=' </p>'
		
		corps+=' <br/> <br/>'
		corps+=' <p class="centre">'

		corps+=' Votre question O/N ?<br />'
		corps+=' <input  type="radio" name="question" value="oui" id="oui" /> <label for="oui">oui</label>'
		corps+=' <input  type="radio" name="question" value="non" id="non" /> <label for="non">non</label>'

		corps+=' </p>'
		corps+=' <br/>'
		
		corps+=' <p class="centre"> Votre question à réponse longue <br/></p>'
		corps+=' <textarea class="centre" name="Sujet de la zone texte" wrap=physical rows=7cols=46></textarea>'
	
	
		corps+=' </form>'
		corps+=' </div>'
		listefonctions.html(corps);
		var centrer = $('.centre');
		centrer.css('margin-left', '25%');
		centrer.css('font-size', '100%');
	}
	
	if(pageToLoad == "pageRadar") {
	
		// ### DEBUT RADAR.PHP ###
		console.log("Page radar");
		
		var radar = $('#radar');
		var corps = '';
		
		// On adapte la taille de la liste à l'espace réel restant
		radar.css('height', y);
		
		// On affiche le radar si celui-ci était caché		
		if(radar.hasClass('hidden')) {
			radar.removeClass('hidden');
		}
		
		// On adapte le radar a l'espace disponible
		adaptListeRadarSize();
		
		console.log("Debut radar");
		
		// On execute le script de création du radar
		$('#spidergraphcontainer').ready(function() {
				 
			$('#spidergraphcontainer').spidergraph4({
				'fields': __LISTEGRILLES__[idGrille].libelleFonctions,
				'gridcolor': 'rgba(0,0,0,1)'   
			});
			
			$('#spidergraphcontainer').spidergraph4('addlayer', { 	
				'strokecolor': 'rgba(0,0,0,1)',
				'fillcolor': __FILLCOLOR__,
				'data': valeursGrille,
				'linear': true
			});    
		});
		
		console.log("Fin radar");
		
		// ### FIN RADAR ###
	}
	
	
	/*
    <span id="questionsReload1" name="mainpages" class="inactive" style="margin:auto; text-align:center;"> 
    
		<?php 
		if ($_SESSION['id_grille'] == 1) {
			include('questionNum.php'); 
		}
		else {
			include('questionON.php'); 
		}
		?>
    
    </span>
	
	<span id="questionsReload2" name="mainpages" class="inactive" style="margin:auto; text-align:center;"> 
    
		<?php 
		if ($_SESSION['id_grille'] == 1) {
			include('questionNum2.php'); 
		}
		else {
			include('questionON2.php'); 
		}
		?>
    
    </span>*/
	
	return corps;

}



// Affiche les nouvelles valeurs aux côtés du thermomètre après mise à jour AGGIR
function updateValeurClinimetreGrille(val_clinimetre) {

        var valgrille = clinimetreToGrille(val_clinimetre);
		var idGrille = __DOCTEUR__.idLastGrille;
		
		if(idGrille==2)
		{
	
		if (valgrille==1)
		$("#valeurgrille").text("C");
		$("#valeurclinimetre").text(val_clinimetre);
		if (valgrille==2)
		$("#valeurgrille").text("B");
		$("#valeurclinimetre").text(val_clinimetre);
		if (valgrille==3)
		$("#valeurgrille").text("B");
		$("#valeurclinimetre").text(val_clinimetre);
		if (valgrille==4)
		$("#valeurgrille").text("B");
		$("#valeurclinimetre").text(val_clinimetre);
		if (valgrille==5)
		$("#valeurgrille").text("A");
		$("#valeurclinimetre").text(val_clinimetre);

		
		}
		
		else
		$("#valeurgrille").text(valgrille);
        $("#valeurclinimetre").text(val_clinimetre);
        
        
}


// Convertir une valeur clinimetre en valeur grille xxxxxxxxxx moquette
function clinimetreToGrille(val_clinimetre) {
	var idGrille = __DOCTEUR__.idLastGrille;
	var __LVLGRILLEMIN__ = __LISTEGRILLES__[idGrille].nivGrilleMin;
	var __LVLGRILLEMAX__ = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var __DELTALVLGRILLE__ = __LVLGRILLEMAX__ - __LVLGRILLEMIN__;
	var __DELTALVLCLINIMETRE__ = __NBLVLCLINIMETRE__ - 1;
	var res = (val_clinimetre - __LVLCLINIMETREMIN__) * __DELTALVLGRILLE__ / __DELTALVLCLINIMETRE__ + parseInt(__LVLGRILLEMIN__);
	if(val_clinimetre==0) { res=0;}
	return Math.round(res);
}

// Convertir une valeur grille en valeur clinimetre
function grilleToClinimetre(val_grille) {
	var idGrille = __DOCTEUR__.idLastGrille;
	var __LVLGRILLEMIN__ = __LISTEGRILLES__[idGrille].nivGrilleMin;
	var __LVLGRILLEMAX__ = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var __DELTALVLGRILLE__ = __LVLGRILLEMAX__ - __LVLGRILLEMIN__;
	var __DELTALVLCLINIMETRE__ = __NBLVLCLINIMETRE__ - 1;
	var res = (val_grille - __LVLGRILLEMIN__) * __DELTALVLCLINIMETRE__ / __DELTALVLGRILLE__ + parseInt(__LVLCLINIMETREMIN__);
	if(val_grille==0) { res=0;}
	return Math.round(res);
}








// Affiche le radar d'une date donnée (historique)
function getRadarDate(date) {
	
	// Aujourd'hui
	var tdy = new Date();
	var strtdy = dateToString(tdy);

	// Demain
	var tmw = new Date();
	tmw.setDate(tmw.getDate()+1);
	
	// Couleur de l'historique
	__FILLCOLOR__ = 'rgba(255,0,0,0.5)';
	
	// Si on demande le radar d'aujourd'hui
	if (dateToString(date) == strtdy) {
		// Couleur d'origine
		__FILLCOLOR__ = 'rgba(193,195,198,0.5)';
	}
	
	// Si on demande le radar de demain
	if(dateToString(date) == dateToString(tmw)){
		alert("Il faut attendre demain...");
	}
	
	// Sinon : cas historique
	else {
		console.log("Historique");

		// On modifie la date courante
		$('#date').html(__PARAMETRES__.currentDate);

		// On affiche le radar adequat
		if(__PARAMETRES__.currentPage == "pageRadar") {updateRadar();}
			
		// Ou affiche la liste adequate
		else if(__PARAMETRES__.currentPage == "pageListe") { console.log('refreshSondage'); refreshSondage(); }

		// On met à jour le curseur
		var idGrille = __DOCTEUR__.idLastGrille;
		var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    	var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
		var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
		var id = parseInt($('#thermometre').attr('name'));
		var valgrille = getCurrentDataGrille()[id];
		var valthermo = valgrille * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
		updateCurseur(valthermo);
		
		// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
        updateValeurClinimetreGrille(grilleToClinimetre(valgrille));        
		
		// On met à jour le détail du score de la fonction courante
		updateSubGrille(valgrille);

		// On interdit la mise à jour si on est pas aujourd'hui
		if(__PARAMETRES__.currentDate == strtdy) {
			console.log("On debloque le thermometre et la liste");
			$("#thermometre").hammer().unbind("release");
			$("#thermometre").find('input').unbind("change");
			$(".sondage").prop("disabled", false);
		}
		else {
			console.log("On bloque le thermometre et la liste");
			$("#thermometre").hammer().bind("release", false);
			$("#thermometre").find('input').bind("change", false);
			$(".sondage").prop("disabled", true);
		}
		
	}	
}


















// Insère dans la base de données les dernières valeurs enregistrées
function updateBDDFromLocalStorage() {

	// Si le navigateur est en ligne
	if(navigator.onLine) {

		// Initialisation des variables
		var idEtablissement = __ETABLISSEMENT__.id;
		var idGrille = __DOCTEUR__.idLastGrille;
		
		var donneesClinimetre = getBufferedDataClinimetre();


		currentDate = new Date(__PARAMETRES__.dateLastSync);
		var strDte = dateToString(currentDate);


		//----------------------------------------------------------------------------------

		// transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
		// Car la date reste la même...

		var donneesClinimetreValeurs = [];

		for(var g = 1 ; g < donneesClinimetre.length ; g ++)
		{

			if(typeof donneesClinimetre[g] == 'undefined')
			{
				donneesClinimetreValeurs[g] = 0;
			}
			else
			{
				donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
			}

		}


		//----------------------------------------------------------------------------------


		var updatesDates = getClinimetreUpdatesDates();
		var dateObjectifs = updatesDates[updatesDates.length - 1];
		var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);

		

		// On montre visuellement qu'une opération est en cours
		$('body').css('opacity', 0.5);

		// Mise à jour des données actuelles
		var request = $.ajax({
			url: "include/updateDonneesClinimetre.php",
			type: "POST",
			data: {
				id_Etablissement: idEtablissement,
				docteur: JSON.stringify(__DOCTEUR__),
				donnees_Clinimetre_Valeur : donneesClinimetreValeurs,
				donnees_Clinimetre_Objectifs : donneesClinimetreObjectifs,
				date_Objectifs : dateObjectifs,
				id_Fonctions : __LISTEGRILLES__[idGrille].idFonctions				
			},
			dataType: 'json',
						success : function(res) {
				console.log(res);
				// On montre visuellement que l'opération terminée avec succès
				$('body').css('opacity', 1);
				loadPage("pageDeConnexion");
// si la sauvegarde s'est bien déroulé on fait une redirection vers la page choix d'un patient
                               
			},
			error : function() {
				//alert("Erreur lors de l'enregistrement des donnees.");
			}
		});
	}

	// Si le navigateur est hors ligne
	else {
		alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
	}
}


//////////////////////////////////////////////////////////////////////////////////////////////////

function imprimer() {

	// Si le navigateur est en ligne
	if(navigator.onLine) {

		// Initialisation des variables
		var idEtablissement = __ETABLISSEMENT__.id;
		var idGrille = __DOCTEUR__.idLastGrille;
		var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;
		var listefonctions = $('#fonctions_liste');
		var libFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
		var donneesClinimetre = getBufferedDataClinimetre();
		currentDate = new Date(__PARAMETRES__.dateLastSync);
		var strDte = dateToString(currentDate);


		//----------------------------------------------------------------------------------

		// transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
		// Car la date reste la même...

		var donneesClinimetreValeurs = [];

		for(var g = 1 ; g < donneesClinimetre.length ; g ++)
		{

			if(typeof donneesClinimetre[g] == 'undefined')
			{
				donneesClinimetreValeurs[g] = 0;
			}
			else
			{
				donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
			}

		}


		//----------------------------------------------------------------------------------


		var updatesDates = getClinimetreUpdatesDates();
		var dateObjectifs = updatesDates[updatesDates.length - 1];
		var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);
		// On montre visuellement qu'une opération est en cours
		$('body').css('opacity', 0.5);

		// Mise à jour des données actuelles
		var request = $.ajax({
			url: "include/updateDonneesClinimetre.php",
			type: "POST",
			data: {
				id_Etablissement: idEtablissement,
				docteur: JSON.stringify(__DOCTEUR__),
				donnees_Clinimetre_Valeur : donneesClinimetreValeurs,
				donnees_Clinimetre_Objectifs : donneesClinimetreObjectifs,
				date_Objectifs : dateObjectifs,
				id_Fonctions : __LISTEGRILLES__[idGrille].idFonctions				
			},
			dataType: 'json',
						success : function(res) {
				console.log(res);
				// On montre visuellement que l'opération terminée avec succès
				$('body').css('opacity', 1);
// si la sauvegarde s'est bien déroulé on fait une redirection vers la page choix d'un patient
                                loadPage("pageRadar");
			},
			error : function() {
				//alert("Erreur lors de l'enregistrement des donnees.");
			}
		});
		
		
		// On récupère les donnée du dernier patient utilé (celui en cours d'utilisation) et on stocke
		// les différentes informations à imprimer dans les variables suivantes. Le patient utilisé
		// est définie par rapport au docteur qui utilise en ce moment l'application: c'est celui utilisé
		// en dernier.
		 var patient = __DOCTEUR__.idLastPatient;
		 var nomImp=__LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom;
		 var impNum=__LISTEPATIENTS__[patient].num_dossier;
		 var impChambre= __LISTEPATIENTS__[patient].num_chambre;
		 var impDateNai=__LISTEPATIENTS__[patient].date_naissance;
		 
		
		 var val=getCurrentDataClinimetre();
		 var corps='';
		 // définition de la page à imprimer
			
			 corps+=' <div id="pageImprime" >' ;
			
			 corps+=' <br> numero de dossier : &nbsp;' + impNum ;
			 
			 corps+=' <br> numero de chambre : &nbsp; ' + impChambre ;
		
			 corps+=' <br> Date de naissance : &nbsp; <br> ' + impDateNai ;
			 
			
			console.log(val.length);
			 
			 for (var h = 1; h<val.length; h++)
			 { 
				console.log("ok");
				corps+=' fonction: '+ libFonctions[h]+'  &nbsp; valeur:  '+val[h] + ' <br> ' ;
			 }

			 corps+=' </div> ';
			 
			 listefonctions.html(corps);
			 
			 
			
			 // fonction qui fait l'action d'imprimer la page
			imprimer_bloc(nomImp, 'pageImprime');
		
			loadPage("pageListe");
			loadPage("pageQuestions");
			loadPage("pageRadar");
		
		
		
	}

	// Si le navigateur est hors ligne
	else {
		alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
	}
}
		




////////////////////////////////////////////////////////////////////////////////////////////////////////




function imprimer_bloc(titre, objet) { 
// Définition de la zone à imprimer 
var zone = document.getElementById(objet).innerHTML; 
 
// Ouverture du popup 
var fen = window.open("", "", "height=500, width=600,toolbar=0, menubar=0, scrollbars=1, resizable=1,status=0, location=0, left=10, top=10"); 
 
// style du popup 
fen.document.body.style.color = '#000000'; 
fen.document.body.style.backgroundColor = '#FFFFFF'; 
fen.document.body.style.padding = "20px"; 
 
// Ajout des données a imprimer 
fen.document.title = titre; 
fen.document.body.innerHTML += " " + zone + " "; 
 
// Impression du popup 
fen.window.print(); 
 
//Fermeture du popup 
fen.window.close(); 
return true; 
} 


/////////////////////////////////////////////////////////////////////////////////////////////////////////

// Fonction d'impression en excel des données en cours


function imprimerExcel() {

	// Si le navigateur est en ligne
	if(navigator.onLine) {

		// Initialisation des variables
		var idEtablissement = __ETABLISSEMENT__.id;
		var idGrille = __DOCTEUR__.idLastGrille;
		var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;
		var listefonctions = $('#fonctions_liste');
		var libFonctions = __LISTEGRILLES__[idGrille].libelleFonctions;
		var donneesClinimetre = getBufferedDataClinimetre();
		currentDate = new Date(__PARAMETRES__.dateLastSync);
		var strDte = dateToString(currentDate);


		//----------------------------------------------------------------------------------

		// transformation d'un tableau a double dimension (donneesClinimetre) en un tableu a une dimension donneesClinimetreValeurs
		// Car la date reste la même...

		var donneesClinimetreValeurs = [];

		for(var g = 1 ; g < donneesClinimetre.length ; g ++)
		{

			if(typeof donneesClinimetre[g] == 'undefined')
			{
				donneesClinimetreValeurs[g] = 0;
			}
			else
			{
				donneesClinimetreValeurs[g] = donneesClinimetre[g][strDte];
			}

		}


		//----------------------------------------------------------------------------------


		var updatesDates = getClinimetreUpdatesDates();
		var dateObjectifs = updatesDates[updatesDates.length - 1];
		var donneesClinimetreObjectifs = getCurrentDataClinimetre(dateObjectifs);
		// On montre visuellement qu'une opération est en cours
		$('body').css('opacity', 0.5);

		// Mise à jour des données actuelles
		var request = $.ajax({
			url: "include/updateDonneesClinimetre.php",
			type: "POST",
			data: {
				id_Etablissement: idEtablissement,
				docteur: JSON.stringify(__DOCTEUR__),
				donnees_Clinimetre_Valeur : donneesClinimetreValeurs,
				donnees_Clinimetre_Objectifs : donneesClinimetreObjectifs,
				date_Objectifs : dateObjectifs,
				id_Fonctions : __LISTEGRILLES__[idGrille].idFonctions				
			},
			dataType: 'json',
						success : function(res) {
				console.log(res);
				// On montre visuellement que l'opération terminée avec succès
				$('body').css('opacity', 1);
// si la sauvegarde s'est bien déroulé on fait une redirection vers la page choix d'un patient
                                loadPage("pageRadar");
			},
			error : function() {
				//alert("Erreur lors de l'enregistrement des donnees.");
			}
		});
		
		
		// On récupère les donnée du dernier patient utilé (celui en cours d'utilisation) et on stocke
		// les différentes informations à imprimer dans les variables suivantes. Le patient utilisé
		// est définie par rapport au docteur qui utilise en ce moment l'application: c'est celui utilisé
		// en dernier.
		 var patient = __DOCTEUR__.idLastPatient;
		 var nomImp=__LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom;
		 var impNum=__LISTEPATIENTS__[patient].num_dossier;
		 var impChambre= __LISTEPATIENTS__[patient].num_chambre;
		 var impDateNai=__LISTEPATIENTS__[patient].date_naissance;
		 
		
		 var val=getCurrentDataClinimetre();
		 var corps='';
		 // définition de la page à imprimer
			
			 corps+=' <div id="pageImprime" >' ;
			
			 corps+=' <br> numero de dossier : &nbsp;' + impNum ;
			 
			 corps+=' <br> numero de chambre : &nbsp; ' + impChambre ;
		
			 corps+=' <br> Date de naissance : &nbsp; <br> ' + impDateNai ;
			 
			
			console.log(val.length);
			 
			 for (var h = 1; h<val.length; h++)
			 { 
				console.log("ok");
				corps+=' fonction: '+ libFonctions[h]+'  &nbsp; valeur:  '+val[h] + ' <br> ' ;
			 }

			 corps+=' </div> ';
			 
			 listefonctions.html(corps);
			 
			 
			
			 // fonction qui fait l'action d'imprimer la page
			imprimer_bloc(nomImp, 'pageImprime');
		
			loadPage("pageListe");
			loadPage("pageQuestions");
			loadPage("pageRadar");
		
		
		
	}

	// Si le navigateur est hors ligne
	else {
		alert("Vous n'est connete a aucun reseau, l'enregistrement restera donc local jusqu'a votre prochaine connexion.");
	}
}



























/////////////////////////////////////////////////////////////////////////////////////////////

// Affiche et gère le menu de recherche de patient

function loadSearchAutoCompletion() {

	// On affiche notre recherche semiautomatique
	$("#searchAfterConnection").removeClass("hidden");

	// On charge la liste de nos patients
	var availableTags = [];
	for (patient in __LISTEPATIENTS__) {
		availableTags.push(__LISTEPATIENTS__[patient].nom + " " + __LISTEPATIENTS__[patient].prenom);
	}

	// On active l'autocompletion
    $("#tags").autocomplete({
    	source: availableTags,

		select : function(event, ui) {
	    	for (patient in __LISTEPATIENTS__) {

				// On ajoute les infos du patient concerné
				if (__LISTEPATIENTS__[patient].nom + ' ' + __LISTEPATIENTS__[patient].prenom == ui.item.value) {
					$("#nomSearch").text(__LISTEPATIENTS__[patient].nom);
    				$("#prenomSearch").text(__LISTEPATIENTS__[patient].prenom);
					$("#adresseSearch").text(__LISTEPATIENTS__[patient].num_chambre);
					$("#dossierSearch").text(__LISTEPATIENTS__[patient].num_dossier);
					$("#dateNaissanceSearch").text(__LISTEPATIENTS__[patient].date_naissance);

					__DOCTEUR__.idLastPatient = patient;
				}
			}
		}
    });
}




// Adapte la taille du radar à l'espace disponible
function adaptListeRadarSize() {

	// Debut précalculs
	var w = Math.min($(window).width(), $(window).height()-325);
	var h = Math.max($(window).width(), $(window).height()-325);
	var v = (h-w)/2;
	
	// Si c'est la page liste
	if(__PARAMETRES__.currentPage == 'pageListe') {
		$('#fonctions_liste').css('height', w);
		$('#champs').css('height', w-50);
	}

	// Sinon on adapte la mise en page du radar
	else if(__PARAMETRES__.currentPage == 'pageRadar') {
		$('#spidergraphcontainer').css('left', v + 'px');
		$('#spidergraphcontainer').css('width', w + 'px');
		$('#spidergraphcontainer').css('height', w + 'px');	
	}
}




// Renvoie la liste des valeurs modifiées depuis la dernière synchro avec la bdd
function getBufferedDataClinimetre() {

	var idGrille = __DOCTEUR__.idLastGrille;
	var idPatient = __DOCTEUR__.idLastPatient;
	
	var nbChampsGrille = __LISTEGRILLES__[idGrille].libelleFonctions.length;
	var donneesPatient = __DONNEESCLINIMETRE__[idPatient];
	var idFonctions = __LISTEGRILLES__[idGrille].idFonctions;

	var updatesDates = getClinimetreUpdatesDates();
	var dateObjectifs = updatesDates[updatesDates.length - 1];

	var valeursBuffered = [];
	var currentDate = '';
	var j = 0;
	var fini = false;

	for(var i = 0; i < nbChampsGrille; i++){
		
		fini = false;

		// On part du jour de la dernière synchronisation avec la BDD
		currentDate = new Date(__PARAMETRES__.dateLastSync);
		
		// Longueur de l'analyse/objectif max (1 an)
		j = 365;
		
		while(!fini) {

			// Modification de la date de la recherche
			strDte = dateToString(currentDate);

			if(typeof donneesPatient[idFonctions[i]][strDte] !== 'undefined') {	
				// Insertion de la valeur
				valeursBuffered[idFonctions[i]] = [];
				valeursBuffered[idFonctions[i]][strDte] = donneesPatient[idFonctions[i]][strDte].valeur;

				/*

				console.log("idFonctions[i] : "+idFonctions[i]);
				console.log("donneesPatient[idFonctions[i]][strDte].valeur : "+ typeof donneesPatient[idFonctions[i]][strDte].valeur);
				console.log("donneesPatient[idFonctions[i]][strDte].valeur : "+ donneesPatient[idFonctions[i]][strDte].valeur);

				*/

			}
			
			// Si on a atteind la dernière date, ou qu'on a atteind la limite contre les boucles infinies 
			if(strDte == dateObjectifs || j == 0) {
				fini = true;
			} else {
				currentDate.setDate(currentDate.getDate() + 1);	
				j--;
			}
		}
	}

	return valeursBuffered;
}

// Fonction Du Grand Pierre Le-Bouar !! 

//fonction question
function question()
{
	var i = parseInt($('#thermometre').attr('name'));
	//On prends la taille de la fonction
	var idGrille = __DOCTEUR__.idLastGrille;
	var idPatient = __DOCTEUR__.idLastPatient;
	var question, reponse, champ_question, champ_reponse;
	var a=0;
	var b=0;
	var c=0;
	var test=false;
	var nomcase=0;
	
	//On mets à jour le titre de la fonction dans le pop up
	document.getElementById("titre_fonct").innerHTML ='QUESTION';
	
	//On mets à jour la description de la fonction
	var texte = document.getElementById("presentation_fonct");
	
	// On régle la taille du pop up
	document.getElementById("popup").style.height='90%';
	document.getElementById("titre_fonct").style.height='40px';
	document.getElementById("presentation_fonct").style.height='87%';
	
	texte.innerHTML='';
	
	champ_question=__LISTEGRILLES__[idGrille].questionLoupe[a][1];
	reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][1];
	
	//On boucle jusqu'à qu'il n'y est plus de question
	while( typeof __LISTEGRILLES__[idGrille].questionLoupe[a]!='undefined')
	{
		
		champ_question=__LISTEGRILLES__[idGrille].questionLoupe[a][1];
		question=__LISTEGRILLES__[idGrille].questionLoupe[a][0];
		
		//On boucle sur toutes les questions et dès que la question fait partie du bon champ on l'affiche
		if(champ_question.toUpperCase()==$("#grille_fonction").text().toUpperCase())
		{
			console.log('question');
			console.log(question);
			b=0;
			//On affiche la question
			texte.innerHTML+='<form method="post" id="question_patient"><p><font size=5>'+question+'</font><br/>';
			
			//On affiche les réponses de la questions
			while( typeof __LISTEGRILLES__[idGrille].reponseLoupe[b]!='undefined')
			{
				champ_reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][1];
				reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][0];
				//
				if(champ_reponse.toUpperCase()==champ_question.toUpperCase() && __LISTEGRILLES__[idGrille].reponseLoupe[b][2]==__LISTEGRILLES__[idGrille].questionLoupe[a][2])
				{
					nomcase='case'+a;
					nomcase=nomcase+b;
					console.log(nomcase);
					c=0;
					test=false;
					//On teste si __REPONSEPATIENT__ existe et si le checked est à 1
					if(typeof(__REPONSEPATIENT__[idPatient])!='undefined' && typeof(__REPONSEPATIENT__[idPatient][idGrille])!='undefined' && typeof(__REPONSEPATIENT__[idPatient][idGrille][__LISTEGRILLES__[idGrille].reponseLoupe[b][2]])!='undefined' && typeof(__REPONSEPATIENT__[idPatient][idGrille][__LISTEGRILLES__[idGrille].reponseLoupe[b][2]][champ_reponse.toUpperCase()])!='undefined' && typeof(__REPONSEPATIENT__[idPatient][idGrille][__LISTEGRILLES__[idGrille].reponseLoupe[b][2]][champ_reponse.toUpperCase()][reponse.toUpperCase()])!='undefined' && __REPONSEPATIENT__[idPatient][idGrille][__LISTEGRILLES__[idGrille].reponseLoupe[b][2]][champ_reponse.toUpperCase()][reponse.toUpperCase()].checked==1)
					{
						var box=$('<input />', {
							id : nomcase, // identifiant de l'élément
							type : "checkbox",
							name : reponse
						}).appendTo(texte)
						box.attr('checked',true);
						$(texte).append(reponse+'<br />');
					}
					//Sinon
					else
					{
						$('<input />', {
								id : nomcase, // identifiant de l'élément
								type : "checkbox"
							}).appendTo(texte);
						$(texte).append(reponse+'<br />');
						
					}
				}
				b++;
			}
		}
		texte.innerHTML+='</p></form>';
		a++;
	}
}

//fonction question
function sauv_rep_question()
{
	var i=0;
	//On prends la taille de la fonction
	var idGrille = __DOCTEUR__.idLastGrille;
	var idPatient = __DOCTEUR__.idLastPatient;
	var question, reponse, champ_question, champ_reponse;
	var a=0;
	var b=0;
	var nomcase=0;
	var idQuestion;
	
	champ_question=__LISTEGRILLES__[idGrille].questionLoupe[a][1];
	reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][1];
	
	while( typeof __LISTEGRILLES__[idGrille].questionLoupe[a]!='undefined')
	{
		
		champ_question=__LISTEGRILLES__[idGrille].questionLoupe[a][1];
		question=__LISTEGRILLES__[idGrille].questionLoupe[a][0];
		//console.log(__REPONSEPATIENT__);
		
		if(champ_question.toUpperCase()==$("#grille_fonction").text().toUpperCase())
		{
			b=0;
			
			while( typeof __LISTEGRILLES__[idGrille].reponseLoupe[b]!='undefined')
			{
				champ_reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][1];
				reponse=__LISTEGRILLES__[idGrille].reponseLoupe[b][0];
				if(champ_reponse.toUpperCase()==champ_question.toUpperCase() && __LISTEGRILLES__[idGrille].reponseLoupe[b][2]==__LISTEGRILLES__[idGrille].questionLoupe[a][2])
				{
					nomcase='case'+a;
					nomcase=nomcase+b;
					nomcase='#'+nomcase;
					console.log(nomcase);
					console.log($(nomcase).prop("checked"));
					if($(nomcase).prop("checked") )
					{
						console.log('checked');
						idQuestion=__LISTEGRILLES__[idGrille].reponseLoupe[b][2];
					
						var requete = $.ajax(
						{
							url      : "include/questionnaire.php",
							type     : "POST",
							data	 : {idDocteur : __DOCTEUR__.id, idPatient : idPatient, idGrille : idGrille, idQuestion : idQuestion, champ : champ_reponse.toUpperCase(), reponse : reponse.toUpperCase(), etat : 1},
							dataType : "json",
							async	 : false,
							success  : function(res){
								
								var varReponsePatient = $.extend( true, __REPONSEPATIENT__, res);
								localStorage.setItem('reponsePatient', JSON.stringify(__REPONSEPATIENT__));
								console.log(__REPONSEPATIENT__);
							
							}
						}).done(function(){
							console.log('sauvegarde de la reponse ' + reponse);
						});
						console.log(JSON.parse(localStorage.getItem('reponsePatient')));
						
					}
					else
					{
						console.log('unchecked');
						idQuestion=__LISTEGRILLES__[idGrille].reponseLoupe[b][2];
						
						var requete = $.ajax(
						{
							url      : "include/questionnaire.php",
							type     : "POST",
							data	 : {idDocteur : __DOCTEUR__.id, idPatient : idPatient, idGrille : idGrille, idQuestion : idQuestion, champ : champ_reponse.toUpperCase(), reponse : reponse.toUpperCase(), etat : 0},
							dataType : "json",
							async	 : false,
							success  : function(res){
								
								var varReponsePatient = $.extend(true, __REPONSEPATIENT__, res);
								localStorage.setItem('reponsePatient', JSON.stringify(__REPONSEPATIENT__));
								console.log(__REPONSEPATIENT__);
							}
						}).done(function(){
							console.log('sauvegarde de la reponse ' + reponse);
						});
								
					}
				}
				b++;
			}
		}
		a++;
	}

}



function aideInterrogation()
{
	//On prends la taille de la fonction
	var idGrille = __DOCTEUR__.idLastGrille;
	document.getElementById("popup").style.height='85%';
	document.getElementById("titre_fonct").style.height='40px';
	document.getElementById("presentation_fonct").style.height='85%';
	document.getElementById("presentation_fonct").innerHTML=__LISTEGRILLES__[idGrille].descriptionGrille;
	document.getElementById("titre_fonct").innerHTML=__LISTEGRILLES__[idGrille].libelle;
	console.log(__LISTEGRILLES__[idGrille].descriptionGrille);
}

function aideGrille()
{
	var i = parseInt($('#thermometre').attr('name'));
	//On prends la taille de la fonction
	var idGrille = __DOCTEUR__.idLastGrille;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var descrfonct = __LISTEGRILLES__[idGrille].descriptionFonctions[i];
	var nbr_colonne =__LISTEGRILLES__[idGrille].nombreDeColonne;
	
	//On adapte la taille des cases
	var popup=document.getElementById("popup");
	var nombre_case;
	nombre_case= lvlgrillemax-lvlgrillemin+1;
	
	var numero_case=0;
	var nom_case;
	var champ;
	var compt=0;
	var tab=[0,0];
	a=0;
	console.log($("#grille_fonction").text().toUpperCase());
	
	if(typeof(__LISTEGRILLES__[idGrille].descriptionChamp[a])!='undefined')
	{
		while(compt<nombre_case)
		{
			champ=__LISTEGRILLES__[idGrille].descriptionChamp[a][1];
			
			if(champ.toUpperCase()==$("#grille_fonction").text().toUpperCase())
			{
				if(typeof(__LISTEGRILLES__[idGrille].descriptionChamp[a])!='undefined')
				{
					console.log(__LISTEGRILLES__[idGrille].descriptionChamp[a][0]);
					tab[compt]=__LISTEGRILLES__[idGrille].descriptionChamp[a][0];
				}
				
				compt++;
			}
			a++;
		}
	}
	
	if(screen.width>850)		//On modifie le CSS pour un pc portable
	{
		//On régle la taille du popup du titre et de la description
		document.getElementById("popup").style.height='650px';
		document.getElementById("titre_fonct").style.height='40px';
		document.getElementById("presentation_fonct").style.height='110px';
		
		if(nbr_colonne==1)
		{
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{		
				// On modifie la taille de la case et de la description
				nom_case='case'+numero_case;
				var case_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
				{
					case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
				}
				else
				{
					case_id.innerHTML =numero_case;
				}
				case_id.style.marginTop=((numero_case-1)*(480/nombre_case))+'px';
				case_id.style.height=(480/nombre_case)+'px';
				case_id.style.visibility="visible";
				case_id.style.marginLeft="0";
				
				nom_case='texte_descr'+numero_case;
				var descr_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
				{
					descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
				}
				else
				{
					descr_id.innerHTML = " ";
				}
				descr_id.style.marginTop=((numero_case-1)*(480/nombre_case))+'px';
				descr_id.style.height=(480/nombre_case)+'px';
				descr_id.style.visibility="visible";
				descr_id.style.marginLeft="5%";
				descr_id.style.width="95%";
				descr_id.style.fontSize="18px";
				
			}
		}
		
		if(nbr_colonne==2)
		{
			var b=0;
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{	
				if((numero_case)%2 == 1)
				{
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-1-b)*(2*420/nombre_case))+'px';
					case_id.style.height=(2*420/nombre_case)+'px';
					case_id.style.visibility="visible";
			
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-1-b)*(2*420/nombre_case))+'px';
					descr_id.style.height=(2*420/nombre_case)+'px';
					descr_id.style.width="43%";
					descr_id.style.visibility="visible";
				}
				else
				{
					// On modifie la case de gauche
					nom_case='case'+numero_case;
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-2-b)*(420/nombre_case)*2)+'px';
					case_id.style.height=(2*420/nombre_case)+'px';
					case_id.style.marginLeft="50%";
					case_id.style.visibility="visible";
					
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-2-b)*(420/nombre_case)*2)+'px';
					descr_id.style.height=(2*420/nombre_case)+'px';
					descr_id.style.width="45%";
					descr_id.style.marginLeft="55%";
					descr_id.style.visibility="visible";
					b++;
				}
				
				
			}
		}
	}
	else if(screen.width<500)		//On modifie le CSS pour un smartphone
	{
		//On régle la taille du popup du titre et de la description
		document.getElementById("popup").style.height='230px';
		document.getElementById("titre_fonct").style.height='10px';
		document.getElementById("presentation_fonct").style.height='50px';
		
		if(nbr_colonne==1)
		{
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{		
				// On modifie la taille de la case et de la description
				nom_case='case'+numero_case;
				var case_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
				{
					case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
				}
				else
				{
					case_id.innerHTML =numero_case;
				}
				descr_id.style.marginTop=((numero_case-1)*(42/nombre_case))+'px';
				case_id.style.height=(73/nombre_case)+'px';
				case_id.style.visibility="visible";
				case_id.style.marginLeft="0";
				
				nom_case='texte_descr'+numero_case;
				var descr_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
				{
					descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
				}
				else
				{
					descr_id.innerHTML = " ";
				}
				descr_id.style.marginTop=((numero_case-1)*(42/nombre_case))+'px';
				case_id.style.height=(73/nombre_case)+'px';
				descr_id.style.visibility="visible";
				descr_id.style.marginLeft="5%";
				descr_id.style.width="95%";
				descr_id.style.fontSize="12px";
				
			}
		}
		
		if(nbr_colonne==2)
		{
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{	
				if((numero_case)%2 == 1)
				{
					// On modifie la case de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=(13+(numero_case-1)*(45/nombre_case))+'%';
					case_id.style.height=(75/nombre_case)+'%';
					
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=(13+(numero_case-1)*(45/nombre_case))+'%';
					descr_id.style.height=(75/nombre_case)+'%';
					descr_id.style.width="45%";
				}
				else
				{
				// On modifie la case de gauche
				nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=(13+(numero_case-2)*(45/nombre_case))+'%';
					case_id.style.height=(75/nombre_case)+'%';
					case_id.style.marginLeft="50%";
					
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=(13+(numero_case-2)*(45/nombre_case))+'%';
					descr_id.style.height=(75/nombre_case)+'%';
					descr_id.style.width="45%";
					descr_id.style.marginLeft="55%";
				}
				
				
			}
		}
	}
	else if (screen.width<screen.height)			//On modifie le CSS pour les tablettes en portrait
	{
	
		//On régle la taille du popup du titre et de la description
		document.getElementById("popup").style.height='850px';
		document.getElementById("titre_fonct").style.height='40px';
		document.getElementById("presentation_fonct").style.height='110px';
		
		for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{		
				// On modifie la taille de la case et de la description
				nom_case='case'+numero_case;
				var case_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
				{
					case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
				}
				else
				{
					case_id.innerHTML =numero_case;
				}
				case_id.style.marginTop=((numero_case-1)*(680/nombre_case))+'px';
				case_id.style.height=(680/nombre_case)+'px';
				case_id.style.visibility="visible";
				case_id.style.marginLeft="0";
				
				nom_case='texte_descr'+numero_case;
				var descr_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
				{
					descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
				}
				else
				{
					descr_id.innerHTML = " ";
				}
				descr_id.style.marginTop=((numero_case-1)*(680/nombre_case))+'px';
				descr_id.style.height=(680/nombre_case)+'px';
				descr_id.style.visibility="visible";
				descr_id.style.marginLeft="5%";
				descr_id.style.width="95%";
				descr_id.style.fontSize="18px";
				
			}
		
		if(nbr_colonne==2)
		{
			var b=0;
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{	
				if((numero_case)%2 == 1)
				{
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-1-b)*(2*600/nombre_case))+'px';
					case_id.style.height=(2*600/nombre_case)+'px';
					case_id.style.visibility="visible";
			
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-1-b)*(2*600/nombre_case))+'px';
					descr_id.style.height=(2*600/nombre_case)+'px';
					descr_id.style.width="43%";
					descr_id.style.visibility="visible";
				}
				else
				{
					// On modifie la case de gauche
					nom_case='case'+numero_case;
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-2-b)*(600/nombre_case)*2)+'px';
					case_id.style.height=(2*600/nombre_case)+'px';
					case_id.style.marginLeft="50%";
					case_id.style.visibility="visible";
					
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-2-b)*(600/nombre_case)*2)+'px';
					descr_id.style.height=(2*600/nombre_case)+'px';
					descr_id.style.width="45%";
					descr_id.style.marginLeft="55%";
					descr_id.style.visibility="visible";
					b++;
				}
				
				
			}
		}
	}
	else				//On modifie le CSS pour les tablettes en paysage
	{
	
		//On régle la taille du popup du titre et de la description
		document.getElementById("popup").style.height='650px';
		document.getElementById("titre_fonct").style.height='40px';
		document.getElementById("presentation_fonct").style.height='110px';
		
		for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{		
				// On modifie la taille de la case et de la description
				nom_case='case'+numero_case;
				var case_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
				{
					case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
				}
				else
				{
					case_id.innerHTML =numero_case;
				}
				case_id.style.marginTop=((numero_case-1)*(480/nombre_case))+'px';
				case_id.style.height=(480/nombre_case)+'px';
				case_id.style.visibility="visible";
				case_id.style.marginLeft="0";
				
				nom_case='texte_descr'+numero_case;
				var descr_id = document.getElementById(nom_case);
				if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
				{
					descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
				}
				else
				{
					descr_id.innerHTML = " ";
				}
				descr_id.style.marginTop=((numero_case-1)*(480/nombre_case))+'px';
				descr_id.style.height=(480/nombre_case)+'px';
				descr_id.style.visibility="visible";
				descr_id.style.marginLeft="5%";
				descr_id.style.width="95%";
				descr_id.style.fontSize="18px";
				
			}
		
		if(nbr_colonne==2)
		{
			var b=0;
			for( numero_case=1;numero_case<(nombre_case+1);numero_case++)
			{	
				if((numero_case)%2 == 1)
				{
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-1-b)*(2*420/nombre_case))+'px';
					case_id.style.height=(2*420/nombre_case)+'px';
					case_id.style.visibility="visible";
			
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-1-b)*(2*420/nombre_case))+'px';
					descr_id.style.height=(2*420/nombre_case)+'px';
					descr_id.style.width="43%";
					descr_id.style.visibility="visible";
				}
				else
				{
					// On modifie la case de gauche
					nom_case='case'+numero_case;
					// On modifie la taille de la case et de la description de droite
					nom_case='case'+numero_case;
					var case_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1])!='undefined')
					{
						case_id.innerHTML =__LISTEGRILLES__[idGrille].valeurFonctions[numero_case-1];
					}
					else
					{
						case_id.innerHTML =numero_case;
					}
					case_id.style.marginTop=((numero_case-2-b)*(420/nombre_case)*2)+'px';
					case_id.style.height=(2*420/nombre_case)+'px';
					case_id.style.marginLeft="50%";
					case_id.style.visibility="visible";
					
					nom_case='texte_descr'+numero_case;
					var descr_id = document.getElementById(nom_case);
					if (typeof(__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]!='undefined'))
					{
						descr_id.innerHTML =__LISTEGRILLES__[idGrille].listeDescValeursGrille[numero_case-1]+' : '+tab[numero_case-1];
					}
					else
					{
						descr_id.innerHTML = " ";
					}
					descr_id.style.marginTop=((numero_case-2-b)*(420/nombre_case)*2)+'px';
					descr_id.style.height=(2*420/nombre_case)+'px';
					descr_id.style.width="45%";
					descr_id.style.marginLeft="55%";
					descr_id.style.visibility="visible";
					b++;
				}
				
				
			}
		}
	}
	
	//On cache les case non utilisé
	for( numero_case=nombre_case+1;numero_case<11;numero_case++)
	{
		// On modifie la taille de la case et de la description
		nom_case='case'+numero_case;
		var case_id = document.getElementById(nom_case);
		case_id.style.visibility="hidden";
		
		nom_case='texte_descr'+numero_case;
		var descr_id = document.getElementById(nom_case);
		descr_id.style.visibility="hidden";
	}
	
	//On mets à jour le titre de la fonction dans le pop up
	document.getElementById("titre_fonct").innerHTML =$("#grille_fonction").text().toUpperCase();
	//On mets à jour la description de la fonction
	document.getElementById("presentation_fonct").innerHTML =descrfonct;
	
	//On affiche le pop up
	popup.style.visibility="visible";
}


//Fonction changeant les valeurs du clinimètre lors de l'utilisation du popup
function sauv_popup(valeur)
{
	//On sauvergarde la valeur sélectionné
	saveLSClinimetreValue(grilleToClinimetre(valeur));
	
	//On mets à jour le radar
	updateRadar();
	
	//On actualise le curseur
	var idGrille = __DOCTEUR__.idLastGrille;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
    var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
	var id = parseInt($('#thermometre').attr('name'));
	var valthermo = valeur * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
	updateCurseur(valthermo);
	
	//On mets à jour la valuer sur les cotés
	updateValeurClinimetreGrille(grilleToClinimetre(valeur));
	
	/*if(document.getElementById('question_patient'))
	{*/
		console.log('le questionnaire est sauvegarde');
		//sauv_rep_question();
	
	fermeture_popup();
}

/* Fonctions d'ouverture et de fermeture du pop up */

function fermeture_popup()
{
	document.getElementById("popup").style.visibility="hidden";
	//On cache les case non utilisé
	var numero_case;
	var nom_case;
	
	for( numero_case=1;numero_case<=10;numero_case++)
	{
		// On modifie la taille de la case et de la description
		nom_case='case'+numero_case;
		var case_id = document.getElementById(nom_case);
		case_id.style.visibility="hidden";
		
		nom_case='texte_descr'+numero_case;
		var descr_id = document.getElementById(nom_case);
		descr_id.style.visibility="hidden";
	}
	
	if(document.getElementById('question_patient'))
	{
		console.log('le questionnaire est sauvegarde');
		sauv_rep_question();
	}
	
	loadPage("pageQuestions");
	loadPage("pageListe");
	loadPage("pageRadar");
	createRadar();
}

function ouverture_popup()
{
	document.getElementById("popup").style.visibility="visible";
	console.log("ouverture pop up");
}

//Surbrillance de la case du popup
function surbrillance_case( carre, texte_desc)
{
	document.getElementById(texte_desc).style.backgroundColor='#FFFFFF';
	document.getElementById(carre).style.textDecoration='underline';
}
function desurbrillance_case( carre, texte_desc)
{
	document.getElementById(texte_desc).style.backgroundColor='#EEEEEE';
	document.getElementById(carre).style.textDecoration='none';
}

//clique sur la bulle
$('html').click(function (e) {
    if ((e.target.id == 'bulle') || (e.target.id == 'popup'))
	{
        ouverture_popup();
		aideGrille();
    }
	else if((e.target.id == 'grille_infos') || (e.target.id == 'popup'))
	{
		ouverture_popup();
		aideInterrogation();
	}
	else if((e.target.id == 'loupe') || (e.target.id == 'popup'))
	{
		ouverture_popup();
		question();
	}
	else
	{
        
    }
});



/* Fonction utilisé dans la partie TEST */

function sendNameAdresseTesteur(name, mail) {

	console.log(name);
	// Si le navigateur est en ligne
			
			console.log("online");
			
			var request = $.ajax({
			url: "include/update.php",
			type: "POST",
			data: {
				name_Testeur: name,
				mail_Testeur: mail				
			},
			dataType: 'json',
						success : function(res) {
				console.log(res);
				if(res.nbConnexion == '100') {
					alert ("Désolé, la partie version de test est limité à 100 utilisation. Pour pouvoir continuer à vous connecté veuillez vous inscrire.");
				}
				else {
					// On peuple les variables globales depuis le localstorage (localstorage si possible mis a jour depuis la bdd)
					loadFromLocalStorage("Admin","Admin");

					// Affiche et gère le menu de recherche de patient
					//loadSearchAutoCompletion();

					// On affiche pas les notes en revanche
					$("#connexion").addClass("hidden");
					$("#noteSearch").addClass("hidden");
					
					// On se connecte toujours sur le même patient dans la version de test
					__DOCTEUR__.idLastPatient = 17;
					
					// On change le nom de la grille en haut à droite car elle ne s'adapte pas sans passer par la selection de grille
					var idGrille = __DOCTEUR__.idLastGrille;
					$("#grille_nom").text(__LISTEGRILLES__[idGrille].libelle);

					// On supprime l'étape de selection du patient en lançant la page radar sur ce click
					
						createRadar();
						loadPage("pageQuestions");
						loadPage("pageListe");
						loadPage("pageRadar");
						createRadar();
					
					// On trig l'évènement "pageloaded"
					$(document).trigger("pageloaded");
				}
			},
			error : function() {
				//alert("Erreur lors de l'enregistrement des donnees.");
			}
		});

	
}






/*
*
*
*
* FIN FONCTIONS TERMINEES
*
*
*
*/