function Patient(nom, prenom, date_naissance, listeValeurs, num_dossier, num_chambre) {
	
	// Attributs et initialisation
	(typeof nom != 'undefined') 			? this.nom = nom 							: this.nom = null;
	(typeof prenom != 'undefined') 			? this.prenom = prenom 						: this.prenom = null;
	(typeof date_naissance != 'undefined')	? this.date_naissance = date_naissance 		: this.date_naissance = null;
	(typeof num_dossier != 'undefined')		? this.num_dossier = num_dossier 			: this.num_dossier = null;
	(typeof num_chambre != 'undefined')		? this.num_chambre = num_chambre 			: this.num_chambre = null;
	(typeof listeValeurs != 'undefined') 	? this.listeValeurs = listeValeurs 			: this.listeValeurs = null;
}

	// Getters
	Patient.prototype.getNom 			= function() { return this.nom; }
	Patient.prototype.getPrenom 		= function() { return this.prenom; }
	Patient.prototype.getDateNaissance 	= function() { return this.date_naissance; }
	Patient.prototype.getNumDossier 	= function() { return this.num_dossier; }
	Patient.prototype.getNumChambre	 	= function() { return this.num_chambre; }
	Patient.prototype.getListeValeurs 	= function() { return this.listeValeurs; }
	
	// Setters
	Patient.prototype.setNom 			= function(nom) 			{ this.nom = nom; }
	Patient.prototype.setPrenom 		= function(prenom) 			{ this.prenom = prenom; }
	Patient.prototype.setDateNaissance 	= function(date_naissance) 	{ this.date_naissance = date_naissance; }
	Patient.prototype.getNumDossier 	= function(num_dossier) 	{ this.num_dossier = num_dossier; }
	Patient.prototype.getNumChambre	 	= function(num_chambre)		{ this.num_chambre = num_chambre; }
	Patient.prototype.setListeValeurs 	= function(listeValeurs) 	{ this.listeValeurs = listeValeurs; }
	
	// Serialiseurs
	Patient.prototype.toString = function() {
		var res = "";
		
		res += "Nom : " 				+ this.nom + "; ";
		res += "Prenom : " 				+ this.prenom + "; ";
		res += "Date de Naissance : " 	+ this.date_naissance + "; ";
		res += "Num. de Dossier	: " 	+ this.num_dossier + "; ";
		res += "Num. de Chambre : " 	+ this.num_chambre + "; ";
		res += "Liste des valeurs : ["	+ this.listeValeurs + "];";
		
		return res;
	}
	
	Patient.prototype.toJSON = function() {
		var res = "{";
		
		res += "nom				: '" + this.nom + "', ";
		res += "prenom			: '" + this.prenom + "', ";
		res += "date_naissance	: '" + this.date_naissance + "', ";
		res += "num_dossier		: '" + this.num_dossier + "', ";
		res += "num_chambre		: '" + this.num_chambre + "', ";
		res += "listeValeurs	: [" + this.listeValeurs + "]";
		
		res += "}";
		
		return res;
	}