<?php
	 
	/* Méthode qui permet de se connecter à une base de données */
	function connexionDB($adresse, $nom, $user, $pwd) {
		try	{	
			// On crée la variable globale "$bdd"
			global $bdd;
			
			// On crée une instance de la classe PDO
			$bdd = new PDO('mysql:host='.$adresse.';dbname='.$nom, $user, $pwd);
		}
		
		catch(Exception $e) {
			//  On affiche un message d'erreur ainsi que les erreurs
			afficher("Echec de la connexion à la base de données<br />Tout ne s\'est pas bien passé, voir les erreurs ci-dessous<br />Erreur : " . $e->getMessage() . "<br />N° : " . $e->getCode());
		 
			// On arrête l'exécution s'il y a du code après
			exit();
		}
	}
	
	
	
	/* Méthode qui permet d'executer des requêtes sur une base de données avec gestion totale des exceptions */
	function cleanPDOQuery($_maRequete) {
		// On tente d'exécuter la requête suivante dans une transaction
		try	{
			// On appelle la variable globale "$bdd" contenant une instance de la classe PDO
			global $bdd;
			
			// On lance la transaction
			$bdd->beginTransaction();
		 
			// Notre requête
			$res = $bdd->query($_maRequete);
		 
			// Si jusque là tout se passe bien, on valide la transaction
			$bdd->commit();
			
			// On retourne le résultat de la requête			
			return $res;
		}
		
		// En cas d'erreur
		catch(Exception $e) {
			// On annule la transation
			$bdd->rollback();
		 
			// On affiche un message d'erreur ainsi que les erreurs
			afficher("Tout ne s\'est pas bien passé, voir les erreurs ci-dessous<br />Erreur : " . $e->getMessage() . "<br />N° : " . $e->getCode());
		 
			// On arrête l'exécution s'il y a du code après
			exit();			
		}
	}
	
	
	// Affiche un message dans une bulle Javascript
	function afficher($texte) {
		echo '<script>alert("' . $texte . '");</script>';
	}
	
	// Convertie une valeur clinimetre en valeur grille en fonction de celle-ci
	function clinimetreToGrille($val_grille, $lvlgrillemin, $lvlgrillemax, $lvlclinimin=0, $lvlclinimax=9) {
		return intval( val_clinimetre * ($lvlgrillemax - $lvlgrillemin) / ($lvlclinimax - $lvlclinimin) + $lvlgrillemin);
	}

	// Convertie une valeur grille en valeur clinimetre en fonction de celle-ci
	function grilleToClinimetre($val_grille, $lvlgrillemin, $lvlgrillemax, $lvlclinimin=0, $lvlclinimax=9) {
		return intval( val_grille * ($lvlclinimax - $lvlclinimin) / ($lvlgrillemax - $lvlgrillemin) - $lvlgrillemin);
	}
	
	// Converti les dates entre JS (/) et SQL (-)
	function dateJStoSQL($date) { return str_replace("/", "-", $date);}
	function dateSQLtoJS($date) { return str_replace("-", "/", $date);}
?>