// Affiche le radar Analyse et Objectifs
function getAnalyseObjectifs() {
	
	if($("#analyse").attr("title") != "active") {
		/* On active la fonction */
		
		// On met à jour le radar en vert
		__FILLCOLOR__ = 'rgba(76,183,72,0.5)';
		
		var requete = $.ajax({
			url      : "include/objectifs.php",
			type     : "GET",
			dataType : "json",
			success  : function(res) {	
				
				// MàJ des variables globales
				__GRILLE__.valeurclinimetre = res.data;
				for(var i = 0; i < __GRILLE__.valeurclinimetre.length-1; i++) {
					__GRILLE__.valeurgrille[i] = clinimetreToGrille(__GRILLE__.valeurclinimetre[i]);
				}
				
				// MàJ du radar
				updateRadar();
				
				// MàJ de la date
				var objdte = new Date(res.date);
				var jour = objdte.getDate();
				if(objdte.getDate() >= 1 && objdte.getDate() <= 9) {
					jour = "0" + objdte.getDate();
				}
				
				__PARAMETRES__.currentPage = objdte.getFullYear() + "-" + (objdte.getMonth()+1) + "-" + jour;
				$('#today').text(__PARAMETRES__.currentPage);
						
				// On met en forme les bouttons Analyses et Historique
				$("#analyse").attr("title", "active");
				$("#analyse").css("color", "rgb(76,183,72)");
				$("#analyse").css("text-shadow", "0px 0px 3px #fff");
				
				$("#today").css("color", "rgb(76,183,72)");
				$("#today").css("text-shadow", "0px 0px 3px #fff");
		
				// Si on clic sur la flèche de gauche
				$("#fleche_bottom_gauche").bind("click", function() {
					
					var tdy = new Date(__PARAMETRES__.currentPage);
					tdy.setDate(tdy.getDate());
					var jour = tdy.getDate();
					if(tdy.getDate() >= 1 && tdy.getDate() <= 9) {
						jour = "0" + tdy.getDate();
					}
					
					dateurl = tdy.getFullYear() + "-" + (tdy.getMonth()+1) + "-" + jour;
							
					var requete = $.ajax({
						url      : "include/objectifs.php?updatedate=" + dateurl,
						type     : "GET",
						dataType : "json",
						success  : function() {	
							__PARAMETRES__.currentPage = dateurl;
							// MàJ du texte
							$('#today').text(__PARAMETRES__.currentPage);
						}
					});
					
				});
				
				
				
				// Si on clic sur la flèche de droite
				$("#fleche_bottom_droite").bind("click", function() {
					
					var tdy = new Date(__PARAMETRES__.currentPage);
					tdy.setDate(tdy.getDate()+1);
					var jour = tdy.getDate();
					if(tdy.getDate() >= 1 && tdy.getDate() <= 9) {
						jour = "0" + tdy.getDate();
					}
					
					dateurl = tdy.getFullYear() + "-" + (tdy.getMonth()+1) + "-" + jour;
					
					var requete = $.ajax({
						url      : "include/objectifs.php?updatedate=" + dateurl,
						type     : "GET",
						dataType : "json",
						success  : function() {
							__PARAMETRES__.currentPage = dateurl;
							// MàJ du texte
							$('#today').text(__PARAMETRES__.currentPage);
						}
					});
					
				});
				
				// Si on clic sur la flèche de droite
				$("#day").bind("click", false);
				
			}
		});
		
	
	} else {
		/* On désactive la fonction */
		
		// On met à jour le radar en gris (couleur par défaut)
		__FILLCOLOR__ = 'rgba(193,195,198,0.5)';
		
		// MàJ de la date du jour
		var today = new Date(); 
		
		getRadarDate(today);
		
		var jour = today.getDate();
		if(jour >= 1 && jour <= 9) {
			jour = "0" + jour;
		}
		__PARAMETRES__.currentPage = today.getFullYear() + "-" + (today.getMonth()+1) + "-" + jour;
		$('#today').text(__PARAMETRES__.currentPage);
		
		// On met en forme les bouttons Analyses et Historique
		$("#analyse").attr("title", "inactive");
		$("#analyse").css("color", "white");
		$("#analyse").css("text-shadow", "");
		
		$("#today").css("color", "white");
		$("#today").css("text-shadow", "");
		
		// On remet les fonctions par défaut sur les listeners
		$("#fleche_bottom_gauche").unbind("click");
		$("#fleche_bottom_droite").unbind("click");
		$("#day").unbind("click");
	}
}















// Affiche le radar d'une date donnée (historique)
function getRadarDate(date) {
	
	var cas = '';
	var offset = 0;
	var idPatient = __DOCTEUR__.idLastPatient;

	// Tableau des dates des différentes mises à jour
	var updatesDates = getClinimetreUpdatesDates();
	var lastUpdateFromToday = updatesDates[updatesDates.length - 1];

	// Aujourd'hui
	var tdy = new Date();
	var strtdy = dateToString(tdy);

	// Demain
	var tmw = new Date();
	tmw.setDate(tmw.getDate() + 1);
	var strtmw = dateToString(tmw);

	// Détermine si on veut une date antérieur ou postérieur
	if(dateToString(date) < __PARAMETRES__.currentDate) { offset = -1;}
	else if(dateToString(date) > __PARAMETRES__.currentDate) { offset = 1;}

	// Met à jour de la date courante avec des valeurs déjà connues
	var index = updatesDates.indexOf(__PARAMETRES__.currentDate) + offset;
	if(index >= 0 && index < updatesDates.length) {
		__PARAMETRES__.currentDate = updatesDates[index];

	}

	// Quitte le mode analyse/objectif
	if(__PARAMETRES__.currentDate == strtmw && offset == -1) {
		__PARAMETRES__.currentDate = dateToString();
	}
	
	// On modifie la couleur
	if (__PARAMETRES__.currentDate < strtdy) {
		// Couleur de l'historique
		__FILLCOLOR__ = 'rgba(255,0,0,0.5)';
		cas = 'historique';
	}
	else if (__PARAMETRES__.currentDate == strtdy) {
		// Couleur d'origine
		__FILLCOLOR__ = 'rgba(193,195,198,0.5)';
		cas = 'today';
	}

	// Si on a demandé l'accès à analyse/objectif (flèche droite quand la currentDate est aujourd'hui)
	if(dateToString(date) > strtdy) {
		// Couleur de l'analyse et objectifs
		__FILLCOLOR__ = 'rgba(112,191,70,0.5)';
		cas = 'objectifs';
	}

	// On affiche le radar adequat
	if(__PARAMETRES__.currentPage == "pageRadar") {updateRadar();}
		
	// Ou affiche la liste adequate
	else if(__PARAMETRES__.currentPage == "pageListe") { refreshSondage(); }

	// Navigation dans l'historique
	if(cas == 'historique') {
		// On interdit la mise à jour si on est pas aujourd'hui
		console.log("On bloque le thermometre et la liste");
		$("#thermometre").hammer().bind("release", false);
		$("#thermometre").find('input').bind("change", false);
		$(".sondage").prop("disabled", true);
	}
	else {
		console.log("On debloque le thermometre et la liste");
		$("#thermometre").hammer().unbind("release");
		$("#thermometre").find('input').unbind("change");
		$(".sondage").prop("disabled", false);
	}

	// Navigation dans les objectifs
	if (cas == 'objectifs') {

		// On modifie la date = J + 14
		tdy.setDate(tdy.getDate() + 14);

		// Si c'est la première fois qu'on passe en mode analyse/objectifs
		if(updatesDates.indexOf(dateToString(tdy)) == -1) {

			// On récupère les donnée d'aujourd'hui
			var currentDataClini = getCurrentDataClinimetre();

			// On adapte la date courante
			__PARAMETRES__.currentDate = dateToString(tdy);

			// On ajoute les données dans le localStorage
			for(var i = 0; i < currentDataClini.length; i++) {
				// Valeur utilisée pour déterminée quelle fonction mettre à jour
				$('#thermometre').attr('name', i);
				saveLSClinimetreValue(currentDataClini[i]);
			}

			// On rétablit la valeur d'origine
			$('#thermometre').attr('name', 0);
		}
	}

	// On met à jour le curseur
	var idGrille = __DOCTEUR__.idLastGrille;
	var lvlgrillemin = __LISTEGRILLES__[idGrille].nivGrilleMin;
	var lvlgrillemax = __LISTEGRILLES__[idGrille].nivGrilleMax;
	var nbValGrille = (lvlgrillemax - lvlgrillemin + 1);
	var id = parseInt($('#thermometre').attr('name'));
	var valgrille = getCurrentDataGrille()[id];
	var valthermo = valgrille * __NBLVLTHERMO__/nbValGrille - __NBLVLTHERMO__/(2*nbValGrille);
	updateCurseur(valthermo);
	
	// On met à jour les valeurs clinimetre et grille aux bords du thermomètre
    updateValeurClinimetreGrille(grilleToClinimetre(valgrille));        
	
	// On met à jour le détail du score de la fonction courante
	updateSubGrille(valgrille);

	// On modifie la date courante
	$('#date').html(__PARAMETRES__.currentDate);

	// On interdit d'aller plus en arrière de l'historique si on est arrivé au bout
	if(__PARAMETRES__.currentDate == updatesDates[0]) {
		$('#fleche_gauche').css('opacity', 0.5);
		$('#fleche_gauche').hammer().bind("release", false);
	}
	else {
		$('#fleche_gauche').css('opacity', 1);
		$('#fleche_gauche').hammer().unbind("release");
	}
}

